/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.logging.IdeLog;
import com.aptana.plist.PListParserFactory;
import com.aptana.theme.ColorManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.internal.OrderedProperties;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextmateImporter {
    private static final String NAME = "name";
    private static final String SCOPE = "scope";
    private static final String FONT_STYLE = "fontStyle";
    private static final String BACKGROUND = "background";
    private static final String FOREGROUND = "foreground";
    private static final String SETTINGS = "settings";

    public Theme convert(File file) {
        try {
            return new Theme(this.getColorManager(), TextmateImporter.convertToProperties(file));
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    private static Properties convertToProperties(File file) throws IOException {
        Map<String, Object> plistProperties = TextmateImporter.parse(file);
        List tokenList = (List)plistProperties.get(SETTINGS);
        Map globals = (Map)((Map)tokenList.get(0)).get(SETTINGS);
        OrderedProperties radRailsProps = new OrderedProperties();
        for (Map.Entry entry : globals.entrySet()) {
            ((Properties)radRailsProps).put(entry.getKey(), entry.getValue());
        }
        ((Properties)radRailsProps).put(NAME, plistProperties.get(NAME));
        tokenList.remove(0);
        for (Map token : tokenList) {
            String fontStyle;
            String bg;
            if (!token.containsKey(SCOPE)) continue;
            String scope = (String)token.get(SCOPE);
            Map colors = (Map)token.get(SETTINGS);
            StringBuilder value = new StringBuilder();
            if (colors.containsKey(FOREGROUND)) {
                String fg = (String)colors.get(FOREGROUND);
                value.append(fg);
            } else if (colors.containsKey(BACKGROUND) || colors.containsKey(FONT_STYLE)) {
                value.append(radRailsProps.getProperty(FOREGROUND));
            }
            if (colors.containsKey(BACKGROUND) && (bg = (String)colors.get(BACKGROUND)) != null && bg.length() > 0) {
                value.append(",");
                value.append(bg);
            }
            if (colors.containsKey(FONT_STYLE) && (fontStyle = (String)colors.get(FONT_STYLE)) != null && fontStyle.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(fontStyle);
                while (tokenizer.hasMoreTokens()) {
                    value.append(",");
                    value.append(tokenizer.nextToken());
                }
            }
            value.append("^").append(scope);
            String name = (String)token.get(NAME);
            ((Properties)radRailsProps).put(name, value.toString());
        }
        return radRailsProps;
    }

    private static Map<String, Object> parse(File file) throws IOException {
        return PListParserFactory.parse((File)file);
    }
}

